#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

void sumSubmatrices(const vector<long long>& arr, int n, int m, int K, int L) {
    int rows = n;
    int cols = m;

    long long result = 0;

    vector<long long> rowSums(rows * (cols + 1), 0);

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < cols; ++j) {
            rowSums[i * (cols + 1) + (j + 1)] = rowSums[i * (cols + 1) + j] + arr[i * cols + j];
        }
    }

    for (int i = 0; i <= rows - L; ++i) {
        for (int j = 0; j <= cols - K; ++j) {
            long long submatrixSum = 0;

            for (int x = i; x < i + L; ++x) {
                submatrixSum += rowSums[x * (cols + 1) + (j + K)] - rowSums[x * (cols + 1) + j];
            }

            result += submatrixSum;
        }
    }

    printf("%lld", result);
}

void centerSpiralSort(vector<long long>& arr) {
    int N = arr.size();
    int left = 0;
    int right = N - 1;

    while (left < right) {
        for (int i = left + 1; i <= right; i++) {
            if (arr[left] > arr[i]) {
                swap(arr[left], arr[i]);
            }
        }
        left++;

        for (int i = right - 1; i >= left; i--) {
            if (arr[right] > arr[i]) {
                swap(arr[right], arr[i]);
            }
        }
        right--;
    }
}

int main() {
    int n, m;
    scanf("%d", &n);
    scanf("%d", &m);
    int K, L;
    scanf("%d", &K);
    scanf("%d", &L);
    vector<long long> arr;

    for (int i = 0; i < n * m; i++) {
        long long tmp;
        scanf("%lld", &tmp);
        arr.push_back(tmp);
    }

    vector<long long> newarr;

    centerSpiralSort(arr);
    int ll=0;
    for(int i=0; i<n;i++){
        vector<long long> t;
        for(int j=0; j<m;j++){
            t.push_back(arr[ll]); 
            ll++;
        }
        
        centerSpiralSort(t);
        for(int j=0; j<m;j++){
            newarr.push_back(t[j]);
        }
       
    }
    sumSubmatrices(newarr, n, m, K, L);

    return 0;

}